#!/bin/sh

DPLY_PAGE_EULA_ACCEPT_RESULT_OK=0
DPLY_PAGE_EULA_ACCEPT_RESULT_ERROR=1
DPLY_PAGE_EULA_ACCEPT_RESULT_CODE=${DPLY_PAGE_EULA_ACCEPT_RESULT_ERROR}

DPLY_PAGE_EULA_ACCEPT_RESULT_MSG=""
DPLY_PAGE_EULA_ACCEPT_RESULT_ROLLING=0

dply_page_eula_accept() {
	debug_print "${0}" "${LINENO}" 'in function "dply_page_eula_accept"'

	tp_yesno \
		"${DPLY_PAGE_EULA_ACCEPT_TITLE}" \
		"${DPLY_PAGE_EULA_ACCEPT_MESSAGE_CONFIRM}" \
		"${DPLY_PAGE_EULA_ACCEPT_LABEL_OK}" \
		"${DPLY_PAGE_EULA_ACCEPT_LABEL_CANCEL}"

    if [ "${TP_YESNO_RESULT_CODE}" == "${TP_YESNO_RESULT_ERROR}" ]; then
		DPLY_PAGE_EULA_ACCEPT_RESULT_CODE=$DPLY_PAGE_EULA_ACCEPT_RESULT_ERROR
		DPLY_PAGE_EULA_ACCEPT_RESULT_MSG=""
		DPLY_PAGE_EULA_ACCEPT_RESULT_ROLLING=0
        return
    fi
        
	case "${TP_YESNO_RESULT_SELECT}" in
    
		"${TP_YESNO_RESULT_YES}")
			DPLY_PAGE_EULA_ACCEPT_RESULT_CODE=$DPLY_PAGE_EULA_ACCEPT_RESULT_OK
			DPLY_PAGE_EULA_ACCEPT_RESULT_MSG=""
			DPLY_PAGE_EULA_ACCEPT_RESULT_ROLLING=1
			;;
			
		"${TP_YESNO_RESULT_NO}")
			DPLY_PAGE_EULA_ACCEPT_RESULT_CODE=$DPLY_PAGE_EULA_ACCEPT_RESULT_OK
			DPLY_PAGE_EULA_ACCEPT_RESULT_MSG=""
			DPLY_PAGE_EULA_ACCEPT_RESULT_ROLLING=-1
			;;
			
		*)
			DPLY_PAGE_EULA_ACCEPT_RESULT_CODE=$DPLY_PAGE_EULA_ACCEPT_RESULT_ERROR
			DPLY_PAGE_EULA_ACCEPT_RESULT_MSG=""
			DPLY_PAGE_EULA_ACCEPT_RESULT_ROLLING=0
			;;
	esac
}